<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Checkout extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library('razorpay_payment');
        $this->load->model('sms_model');
    }

    public function check($id=NULL)
    {
    	if( !is_guest_loggedin() ):
    		show_404();
    	endif;
    	if( !$id ):
    		show_404();
    	endif;

        if( $this->input->post('transaction_no') )
        {
            $this->cash($id, 'UPI');
            exit();
        }

    	$config = $this->get_payment_config();

    	if ($config['razorpay_key_id'] == "" || $config['razorpay_key_secret'] == "")
        {
            set_alert('error', 'Razorpay config not available');
            redirect($_SERVER['HTTP_REFERER']);
        } else {

        	$charges = $this->db->get_where('setting', array('is_payment_active'))->row();
        	$head = $this->db->get_where('family_head', array('id'=>$id))->row_array();
			$no_of_member = $this->db->get_where('family_head', array('family_head_id'=> $head['id'], 'status'=> 1))->num_rows();
			$total_amount = ($no_of_member+1) * $charges->per_member_charge;

        	$params = array(
        		'head_id' => $head['id'],
        		'amount' => $total_amount,
        	);
        	$response = $this->razorpay_payment->payment($params);

        	$params['razorpay_order_id'] = $response;
            $params['next_due_date'] = $charges->next_due_date;
        	$params = array_merge($params,$head);
        	$this->session->set_userdata("params", $params);

        	$arrayData = array(
                'key' => $config['razorpay_key_id'], 
                'amount' => ($params['amount'])*100, 
                'name' => $head['name'], 
                'description' => "Submitting amount online. for head code - " . $params['head_id'], 
                'currency' => 'INR', 
                'order_id' => $params['razorpay_order_id'], 
                'theme' => ["color" => "#fb0"],
            );
            $data['return_url'] = base_url('member/profile');
            $data['pay_data'] = json_encode($arrayData);

            $this->load->view('layouts/razorpay', $data);

        }

    }


    public function get_payment_config()
    {
        $config['razorpay_key_id'] = "rzp_test_6jHLOyZabczJjW";
        $config['razorpay_key_secret'] = "mUNRtXLUjFKKPwMCz5LGHXlr";
        return $config;
    }


    public function razorpay_verify()
    {
        $params = $this->session->userdata('params');

        if ($this->input->post('razorpay_payment_id'))
        {
            // null session data
            $this->session->set_userdata("params", "");
            $attributes = array(
                'razorpay_order_id' => $params['razorpay_order_id'],
                'razorpay_payment_id' => $this->input->post('razorpay_payment_id'),
                'razorpay_signature' => $this->input->post('razorpay_signature')
            );

            $response = $this->razorpay_payment->verify($attributes);

            if ($response == TRUE)
            {
                // payment info update in payment_trx
                $params = array_merge($params, $attributes);
                $this->savePaymentData($params);
                set_alert('success', 'Payment Successfull');
                redirect(base_url('member/profile'));
            } else {
                set_alert('error', $response);
                redirect(base_url('member/profile')); 
            }
        }
    }

    public function savePaymentData($data)
    {
    	$array_data = array(
    		'head_id' => $data['head_id'],
    		'razorpay_order_id' => $data['razorpay_order_id'],
    		'razorpay_payment_id' => $data['razorpay_payment_id'],
    		'razorpay_signature' => $data['razorpay_signature'],
    		'amount' => $data['amount'],
            'receipt_date' => date('Y-m-d')
    	);

    	$this->db->insert('payment_trx', $array_data);

        $members = $this->db->select('id')->get_where('family_head', array('family_head_id'=>$head_id))->result();
        $max_id = $this->db->select("IFNULL(MAX(member_id), 0)+1 as member_id")->get_where('family_head', array('due_date IS NOT NULL'=>NULL))->row()->member_id;
    	$this->db->where('id', $data['head_id'])->or_where('family_head_id',$data['id'])->update('family_head', array('payment_status'=> 1, 'due_date'=>$data['next_due_date'], 'member_id'=>$max_id));

        foreach( $members as $m ):
            $max_id = $this->db->select("IFNULL(MAX(member_id), 0)+1 as member_id")->get_where('family_head', array('due_date IS NOT NULL'=>NULL))->row()->member_id;
            $this->db->where('id', $m->id)->update('family_head', array('member_id'=>$max_id));
        endforeach;

        // send sms
        // $template = $this->db->get_where('sms_templates', array('id'=>1))->row();
        // $mobile = $data['mobile'];
        // $message = $template->template;
        // $message = str_replace("[NAME]", $data['name'] , $message);
        // $response = $this->sms_model->send($message, $mobile);
    }


    public function cash( $head_id, $mode='Cash' )
    {
        // if( !is_loggedin() ):
        //     show_404();
        // endif;
        if( !$head_id ):
            show_404();
        endif;

        $charges = $this->db->get_where('setting', array('is_payment_active'))->row();
        $head = $this->db->get_where('family_head', array('id'=>$head_id))->row_array();
        $no_of_member = $this->db->get_where('family_head', array('family_head_id'=> $head_id, 'status'=> 1))->num_rows();
        $total_amount = ($no_of_member+1) * $charges->per_member_charge;

        $array_data = array(
            'head_id' => $head_id,
            'razorpay_order_id' => NULL,
            'razorpay_payment_id' => $_POST['transaction_no'] ? $_POST['transaction_no'] : NULL,
            'razorpay_signature' => NULL,
            'mode' => $mode,
            'amount' => $total_amount,
            'receipt_date' => $_POST['manual_date'] ? date('Y-m-d', strtotime($_POST['manual_date'])) : date('Y-m-d'),
            'receipt_no' => $_POST['receipt_no']
        );

        $this->db->insert('payment_trx', $array_data);
        

        $members = $this->db->select('id')->get_where('family_head', array('family_head_id'=>$head_id))->result();
        $max_id = $this->db->select("IFNULL(MAX(member_id), 0)+1 as member_id")->get_where('family_head', array('due_date IS NOT NULL'=>NULL))->row()->member_id;

        $this->db->where('id', $head_id)->or_where('family_head_id',$head_id)->update('family_head', array('payment_status'=> 1, 'due_date'=>$charges->next_due_date, 'member_id'=>$max_id));

        foreach( $members as $m ):
            $max_id = $this->db->select("IFNULL(MAX(member_id), 0)+1 as member_id")->get_where('family_head', array('due_date IS NOT NULL'=>NULL))->row()->member_id;
            $this->db->where('id', $m->id)->update('family_head', array('member_id'=>$max_id));
        endforeach;
        // send sms
        // $template = $this->db->get_where('sms_templates', array('id'=>1))->row();
        // $mobile = $head['mobile'];
        // $message = $template->template;
        // $message = str_replace("[NAME]", $head['name'] , $message);
        // $response = $this->sms_model->send($message, $mobile);
        if( $mode == 'UPI' )
        {
            set_alert('success', 'Payment Successfull');
            redirect(base_url('member/profile'));
        }else{
            set_alert('success', 'Payment Successfull');
            $this->session->unset_userdata('member_mobile');
            redirect( base_url('family/index') );
        }

    }

}