<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Family extends Admin_Controller {

	public function index( $head_id=NULL )
	{
		// member charges setting
		$charges = $this->db->get_where('setting', array('is_payment_active'))->row();
		if( $head_id ):
			// family head info
			$member_head = $this->db->get_where('family_head', array('id'=>$head_id))->row();
			$this->session->set_userdata('member_mobile', $member_head->mobile);
			// member info
			$family_members = $this->db->select('fm.*, rm.name as relation_en, rm.name_h as relation_h')
				->from('family_head fm')
				->join('relation_master as rm', 'rm.id = fm.relation', 'left')
				->group_start()
				->where('fm.family_head_id', $head_id)
				->or_where('fm.id', $head_id)
				->group_end()
				->get();
			$no_of_member = $family_members->num_rows();
			$total_amount = ($no_of_member) * $charges->per_member_charge;

			$this->data['head'] = $member_head;
			$this->data['members'] = $family_members->result();
			$this->data['no_of_member'] = $no_of_member;
			$this->data['total_amount'] = $total_amount;
			$this->data['checkout_url'] = base_url('checkout/cash/').@$head_id;
		endif;

		$this->data['action_head'] = base_url('member/save/head_save/').@$head_id;
		$this->data['member_create'] = base_url('member/create/');
		$this->data['charge'] = $charges;
		$this->data['sub_page'] = 'member/profile';
		$this->load->view('layouts/index', $this->data);
	}


	public function list()
	{
		// $this->data['rows'] = $this->db->select('fh.*, fhh.name as head, rm.name as relation_en, rm.name_h as relation_h, pt.razorpay_payment_id, pt.receipt_date, pt.receipt_no, pt.amount, pt.mode')
		// 	->from('family_head fh')
		// 	->join('family_head fhh', 'fhh.id = fh.family_head_id', 'left')
		// 	->join('relation_master as rm', 'rm.id = fh.relation', 'left')
		// 	->join('payment_trx pt', 'pt.head_id = fh.id', 'left')
		// 	->where('fh.NAME IS NOT NULL', null)
		// 	->where('fh.due_date IS NOT NULL', NULL)
		// 	->order_by('fh.id ASC, fhh.id ASC')->get()->result();


		$rows = $this->db->select('fh.*, pt.razorpay_payment_id, pt.receipt_date, pt.receipt_no, pt.amount, pt.mode')
			->from('family_head fh')
			->join('payment_trx pt', 'pt.head_id = fh.id', 'left')
			->where('fh.NAME IS NOT NULL', null)
			->where('fh.due_date IS NOT NULL', NULL)
			->where('fh.family_head_id IS NULL', NULL)
			->order_by('fh.member_id DESC')->get()->result();

		foreach ($rows as $key => $value) {
			$value->f_mambers = $this->db->select('fh.*,rm.name as relation_en, rm.name_h as relation_h,')
			->from('family_head fh')
			->join('relation_master as rm', 'rm.id = fh.relation', 'left')
			->where('fh.NAME IS NOT NULL', null)
			->where('fh.due_date IS NOT NULL', NULL)
			->where('fh.family_head_id', $value->id)
			->order_by('fh.member_id ASC')->get()->result();
		}

		$this->data['rows'] = $rows;
		$this->data['sub_page'] = 'member/list';
		$this->data['view_url'] = base_url('family/view/');
		$this->load->view('layouts/index', $this->data);
	}

	public function temp()
	{
		$rows = $this->db->select('fh.*')
			->from('family_head fh')
			->join('family_head fhh', 'fhh.id = fh.family_head_id', 'left')
			->join('relation_master as rm', 'rm.id = fh.relation', 'left')
			->where('fh.due_date IS NULL', NULL)
			->where('fh.family_head_id IS NULL', NULL)
			->order_by('fh.id DESC')->get()->result();

		foreach ($rows as $key => $value) {
			$value->f_mambers = $this->db->select('fh.*,rm.name as relation_en, rm.name_h as relation_h')
			->from('family_head fh')
			->join('relation_master as rm', 'rm.id = fh.relation', 'left')
			->where('fh.family_head_id', $value->id)
			->order_by('fh.id ASC')->get()->result();
		}
		$this->data['rows'] 	= $rows;
		$this->data['sub_page'] = 'member/temp_list';
		$this->data['view_url'] = base_url('family/view/');
		$this->load->view('layouts/index', $this->data);
	}

	public function view( $head_id=NULL )
	{
		if( $head_id ):
			$this->data['rows'] = $this->db->get_where('family_member', array('family_head_id'=>$head_id))->result();
			$this->load->view('member/view', $this->data);
		else:
			echo 'No Data Available';
		endif;
	}

	public function delete($id=NULL)
	{
		$data = array(
			'status' => 'error',
			'message' => 'Data Not Deleted!',
			'url' => ''
		);
		if( $this->db->group_start()
			->where('id', $id)
			->or_where('family_head_id', $id)
			->group_end()
			->delete('family_head') ):

			$data = array(
				'status' => 'success',
				'message' => 'Data Deleted Successfully!',
				'url' => ''
			);
		endif;
		echo json_encode($data);
	}
}
