<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Member extends CI_Controller {

	public function index()
	{
		// check if user authenticated via otp
		if( isset( $this->session->member_mobile ) && isset( $this->session->verified ) ):
			redirect( base_url('member/profile') );
		endif;
		$this->data['action_url'] = base_url('member/get_otp');
		$this->data['action_url'] = base_url('member/check_otp');
		$this->data['action_otp'] = base_url('member/check_otp');
		$this->data['sub_page'] = 'member/index';
		$this->load->view('layouts/index.php', $this->data);
	}

	public function get_otp()
	{
		$this->load->model('sms_model');
		$template = $this->db->get_where('sms_templates', array('id'=>2))->row();
		$mobile = $this->input->get_post('contact');
		$otp = 123456;

		$message = $template->template;
		$message = str_replace("[OTP]", $otp , $message);
		$message = str_replace("[MOBILE]", $mobile , $message);
		$this->session->set_tempdata('member_otp', $otp, 300);
		// $response = $this->sms_model->send($message, $mobile);

		$this->session->set_userdata('member_mobile', $mobile);

		$data = array(
			'status' => 'success',
			'message' => 'OTP Send Successfully!',
			'url' => ''
		);

		echo json_encode($data);
        exit();
	}

	public function check_otp()
	{
		$this->session->set_tempdata('member_otp', 123456, 300);
		$this->session->set_userdata('member_mobile', $_POST['contact']);
		
		// $member_otp = $this->input->get_post('member_otp');
		$member_otp = 123456;

		if( $member_otp == $this->session->member_otp ):
			$this->session->set_userdata('verified', true);
			$this->session->unset_userdata('member_otp');

			// $num = $this->db->get_where('family_head', array('mobile'=>$this->session->member_mobile))->num_rows();
			// if( $num <= 0 ):
			// 	$this->db->insert('family_head', array('mobile'=>$this->session->member_mobile));
			// endif;

            $data = array(
				'status' => 'success',
				'message' => 'Mobile No. Registered Successfully!',
				'url' => base_url('member/profile')
			);
		else:
            $data = array(
				'status' => 'error',
				'message' => 'You Entered Wrong OTP',
				'url' => ''
			);
		endif;

		echo json_encode($data);
        exit();
	}

	public function profile()
	{
		// check if user is not authenticated via otp
		if( !isset( $this->session->member_mobile ) || !isset( $this->session->verified ) ):
			redirect( base_url('member') );
		endif;

		// member charges setting
		$charges = $this->db->get_where('setting', array('is_payment_active'))->row();

		// family head info
		$member_head = $this->db->get_where('family_head', array('mobile'=>$this->session->member_mobile, 'family_head_id IS NULL'=>null))->row();

		if( $member_head ):
		// member info
		$family_members = $this->db->select('fm.*, rm.name as relation_en, rm.name_h as relation_h')
			->from('family_head fm')
			->join('relation_master as rm', 'rm.id = fm.relation', 'left')
			->group_start()
			->where('fm.family_head_id', $member_head->id)
			->or_where('fm.id', $member_head->id)
			->group_end()
			->get();
		$no_of_member = $family_members->num_rows();
		$family_members_list = $family_members->result();
		$total_amount = ($no_of_member) * $charges->per_member_charge;
		else:
			$this->session->sess_destroy();
			show_404(); die;
			$member_head = new \stdClass();;
			$member_head->mobile = $this->session->member_mobile;
			$family_members = array();
			$no_of_member = 0;
			$family_members_list = array();
			$total_amount = 0;
		endif;

		$this->data['member_create'] = base_url('member/create/');
		$this->data['action_head'] = base_url('member/save/head_save/').@$member_head->id;
		$this->data['checkout_url'] = base_url('checkout/check/').@$member_head->id;
		$this->data['charge'] = $charges;
		$this->data['head'] = $member_head;
		$this->data['members'] = $family_members_list;
		$this->data['no_of_member'] = $no_of_member;
		$this->data['total_amount'] = $total_amount;
		$this->data['sub_page'] = 'member/profile';
		$this->load->view('layouts/index', $this->data);
	}

	public function create($id=NULL)
	{
		$this->data['head'] = get_family_head();
		if( $id ):
			$this->data['member'] =  $this->db->get_where('family_head', array('id'=>$id))->row();
		endif;
		$this->data['action_member'] = base_url('member/save/member_save/').$id;
		$this->load->view('member/member_create', $this->data);
	}

	public function save($action=NULL,$id=NULL)
	{
		$data = array(
			'status' => 'error',
			'message' => 'Not Saved!',
			'url' => ''
		);
		switch($action){
			case 'head_save':
				if( $id ):
					if( $this->db->where('id', $id)->update('family_head', $_POST) ):
						$data = array(
							'status' => 'success',
							'message' => 'Saved Successfully!',
							'url' => ''
						);
					endif;
				else:
					// if( !@$_POST['due_date'] ):
					// 	$_POST['due_date'] = NULL;
					// endif;
					if( $this->db->insert('family_head', $_POST) ):
						$insert_id = $this->db->insert_id();
						if( is_loggedin() ):
							$url = base_url('family/index/').$insert_id;
						else:
							$url = '';
						endif;
						$data = array(
							'status' => 'success',
							'message' => 'Saved Successfully!',
							'url' => $url
						);
					endif;
				endif;
				echo json_encode($data);
				break;
			case 'member_save':
				if( $id ):
					if( $this->db->where('id', $id)->update('family_head', $_POST) ):
						$data = array(
							'status' => 'success',
							'message' => 'Saved Successfully!',
							'url' => ''
						);
					endif;
				else:
					$this->db->insert('family_head', $_POST);
					$data = array(
						'status' => 'success',
						'message' => 'Saved Successfully!',
						'url' => ''
					);
				endif;
				echo json_encode($data);
				break;
			default:
    			show_404();
		}
	}

	public function check_mobile($action=NULL,$id=NULL)
	{
		$mobile = $this->input->get_post('mobile');
		if( $id ):
			$this->db->where('id <>', $id);
		endif;
		$this->db->where('mobile', $mobile);
		$rows = $this->db->get('family_head')->num_rows();

		if( $rows <= 0 ):
			echo 'true';
		else:
			echo 'false';
		endif;
	}


	public function check_aadhar($action=NULL,$id=NULL)
	{
		$aadhar = $this->input->get_post('aadhar');
		$cond_member = $cond_head = '';
		if( $id ):
			$this->db->where('id <>', $id);
		endif;
		$num = $this->db->where('aadhar', $aadhar)
			->from('family_head')->get()->num_rows();
		if($num <= 0 ):
			echo 'true';
		else:
			echo 'false';
		endif;
	}

	public function logout()
	{
		$this->session->unset_userdata('member_mobile');
        $this->session->sess_destroy();
        redirect(base_url(), 'refresh');
	}
}
