<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sms_config extends Admin_Controller {

	public function view(  )
	{
		$this->data['tb_url'] = base_url('sms_config/tb/');
		$this->data['config_url'] = base_url('sms_config/create/config/');
		$this->data['duedate_url'] = base_url('sms_config/create/duedate/');
		$this->data['sub_page'] = 'sms_config/index';
		$this->load->view('layouts/index', $this->data);
	}


	public function tb()
	{
		$this->data['rows'] = $this->db->get('sms_templates')->result();
		$this->data['action_url'] = base_url('sms_config/save/template/');
		$this->load->view('sms_config/create_template', $this->data);
	}


	public function create( $action=NULL,$id=NULL )
	{
		switch( $action ){
			case 'template':
				$this->data['rows'] = $this->db->get_where('sms_templates', array('id'=>$id))->row();
				$this->data['action_url'] = base_url('sms_config/save/template/').$id;
				$this->load->view('sms_config/create_template', $this->data);
				break;
			case 'config':
				$this->data['row'] = $this->db->get_where('sms_config')->row();
				$this->data['action_url'] = base_url('sms_config/save/config');
				$this->load->view('sms_config/create_config', $this->data);

				break;

			case 'duedate':
				$this->data['row'] = $this->db->get_where('setting')->row();
				$this->data['action_url'] = base_url('sms_config/save/duedate');
				$this->load->view('sms_config/create_duedate', $this->data);

				break;
		}
		
	}

	public function save($action=NULL,$id=NULL)
	{
		$data = array(
			'status' => 'error',
			'message' => 'Data not saved!',
			'url' => ''
		);
		switch($action)
		{
			case 'template':
				if( $id ):
					$this->db->where('id',$id)->update('sms_templates', $_POST);
					$data = array(
						'status' => 'success',
						'message' => 'Data saved successfully!',
						'url' => '' 
					);
				endif;
				echo json_encode($data);
				break;
			case 'config':
				$row = $this->db->get_where('sms_config')->row();
				if( $row ):
					$this->db->where('id',$row->id)->update('sms_config', $_POST);
					$data = array(
						'status' => 'success',
						'message' => 'Data saved successfully!',
						'url' => ''
					);
				else:
					$this->db->insert('sms_config', $_POST);
					$data = array(
						'status' => 'success',
						'message' => 'Data saved successfully!',
						'url' => ''
					);
				endif;
				echo json_encode($data);
				break;

			case 'duedate':
				
					$this->db->where('id',1)->update('setting', $_POST);
					$data = array(
						'status' => 'success',
						'message' => 'Data saved successfully!',
						'url' => '' 
					);
				
				echo json_encode($data);
				break;

			default:
				show_404();
		}

	}

}
