<div class="card">
	<div class="card-body">
		<form class="row g-3 member-form ajax-submit page-reload translate" method="POST" action="<?= $action_member ?>">
			<input type="hidden" name="family_head_id" value="<?= @$head->id ?>">

			<div class="row">
				<div class="col-md-6">
					<div class="col-md-12">
						<label for="name" class="form-label">Name</label>
						<input type="text" class="form-control name" placeholder="Name" name="name" value="<?= @$member->name ?>" style="text-transform: capitalize;" capitalize />
					</div>
					<div class="col-md-12">
						<label for="city" class="form-label">Mobile</label>
						<input type="number" class="form-control mobile" placeholder="mobile" name="mobile" autocomplete="off" value="<?= @$member->mobile ?>" />
					</div>
					<div class="col-md-12">
						<label for="aadhar" class="form-label">Aadhar <small class="text-danger">(last four digit)</small></label>
						<input type="number" class="form-control mobile" placeholder="Aadhar" name="aadhar" autocomplete="off" value="<?= @$member->aadhar ?>" />
					</div>
					<div class="col-md-12">
						<label for="mobile" class="form-label">Relation With Family Head</label>
						<?php
							$relations = $this->app_lib->get_relation();
							echo form_dropdown('relation', $relations, set_value('relation', @$member->relation), "class='form-control'")
						?>
					</div>
					<div class="col-12">
						<label for="inputAddress" class="form-label">Age</label>
						<input type="number" class="form-control age" placeholder="Age" name="age" autocomplete="off" min=0 value="<?= @$member->age ?>" />
					</div>
				</div>

				<div class="col-md-6">
					<div class="col-md-12">
						<label for="name" class="form-label">नाम</label>
						<input type="text" class="form-control name_h" placeholder="नाम" name="name_h" value="<?= @$member->name_h ?>" readonly/>
					</div>
					<div class="col-md-12">
						<label for="city" class="form-label">फ़ोन</label>
						<input type="number" class="form-control mobile_h" placeholder="फ़ोन" autocomplete="off" value="<?= @$member->mobile ?>" readonly/>
					</div>
					<div class="col-md-12">
						<label for="aadhar" class="form-label">आधार संख्या <small class="text-danger">(अंतिम चार अंक)</small></label>
						<input type="number" class="form-control aadhar_h" placeholder="आधार संख्या"  autocomplete="off" value="<?= @$member->aadhar ?>" />
					</div>
					<div class="col-md-12">
						<label for="mobile" class="form-label">परिवार के मुखिया के साथ संबंध</label>
						<?php
							$relations = $relations = $this->app_lib->get_relation('hi');
							echo form_dropdown('', $relations, set_value('relation_h', @$member->relation_h), "class='form-control relation_h' readonly")
						?>
					</div>
					<div class="col-12">
						<label for="inputAddress" class="form-label">आयु</label>
						<input type="number" class="form-control age_h" placeholder="आयु" autocomplete="off" min=0 value="<?= @$member->age ?>" readonly/>
					</div>
				</div>

			</div>

			<div class="col-12">
				<button type="submit" class="btn btn-success">Save</button>
			</div>
		</form>
	</div>
</div>


<script type="text/javascript">
	$(document).ready(function(){
		$('.member-form').validate({
			rules : {
				name:{
					required : true,
				},
		        mobile : {
		        	minlength : 10,
		        	maxlength : 10,
		        	remote : '<?= base_url() ?>member/check_mobile/member/<?= @$member->id ?>'
		        },
		        relation : {
		        	required : true,
		        },
		        age:{
		        	age_check : true,
		        },
		        aadhar:{
		        	required : true,
		        	minlength : 4,
		        	maxlength : 4,
		        	remote : '<?= base_url() ?>member/check_aadhar/member/<?= @$member->id ?>'
		        }
		    },
		    messages:{
		    	mobile:{
		    		minlength: 'Please enter 10 digit mobile number',
		    		maxlength: 'Please enter 10 digit mobile number',
		    		remote: 'This Moible is already exist!'
		    	},
		    	aadhar:{
		    		minlength: 'Please enter last 4 digit of aadhar',
		    		maxlength: 'Please enter last 4 digit of aadhar',
		    		remote : 'This aadhar No is already exists!'
		    	}
		    }
		});

		$.validator.addMethod('age_check', function(value) {
            return parseFloat(value) < 150;
        }, 'Age should be valid!');
	});
</script>