<div class="container padding--top padding--bottom bg-light">

	<div class="row border bg-light text-center">
		<?php if( strtotime(@$head->due_date) >= strtotime(date('Y-m-d')) ): ?>
			<strong class="text-success">Membership is valid till date <?=@$head->due_date?> </strong>
		<?php else: ?>
			<strong class="text-danger"> Please pay the membership charges to become Member </strong>
		<?php endif; ?>

	</div>

	<div class="section__header text-center">
        <h2>Head of Family</h2>
        <p></p>
    </div>
    <div class="card">
		<div class="card-body">
			<form class="row g-3 head-form ajax-submit translate page-reload" method="POST" action="<?= $action_head ?>">
				<input type="hidden" name="id" value="<?= @$head->id ?>">

				<div class="col-md-4">
					<label for="mobile" class="form-label">Mobile</label>
					<input type="number" class="form-control mobile" placeholder="Mobile" name="mobile" value="<?= set_value('mobile', @$head->mobile) ?>" <?= is_loggedin() ? '' : 'readonly' ?> />
					<input type="number" class="form-control mobile_h" placeholder="Mobile" value="<?= set_value('mobile', @$head->mobile) ?>" readonly />
				</div>

				<div class="col-md-4">
					<label for="name" class="form-label">Name</label>
					<input type="text" class="form-control name" placeholder="Name" name="name" value="<?= @$head->name ?>" style="text-transform: capitalize;" capitalize/>
					<input type="text" class="form-control name_h" placeholder="Name" name="name_h" value="<?= @$head->name_h ?>" readonly/>
				</div>

				<div class="col-md-4">
					<label for="father_husbandname" class="form-label">Father / Husband Name</label>
					<input type="text" class="form-control father_husband" placeholder="Father/Husband Name" name="father_husband" value="<?= @$head->father_husband ?>" style="text-transform: capitalize;" capitalize />
					<input type="text" class="form-control father_husband_h" placeholder="Father / Husband Name" name="father_husband_h" value="<?= @$head->father_husband_h ?>" readonly/>
				</div>

				<div class="col-md-4">
					<label for="mobile" class="form-label">Age </label>
					<input type="number" class="form-control age" placeholder="Age" name="age" value="<?= set_value('age', @$head->age) ?>">
					<input type="number" class="form-control age_h" placeholder="आयु" value="<?= set_value('age', @$head->age) ?>" readonly />
				</div>

				<div class="col-md-4">
					<label for="mobile" class="form-label">Aadhar No. <span class="text-danger">(last four digit)</span> </label>
					<input type="number" class="form-control aadhar" placeholder="Aadhar" name="aadhar" value="<?= set_value('aadhar', @$head->aadhar) ?>">
					<input type="number" class="form-control aadhar_h" placeholder="आधार संख्या" value="<?= set_value('mobile', @$head->aadhar) ?>" readonly />
				</div>
				<div class="col-md-4">
					<label for="inputAddress" class="form-label">Address</label>
					<input type="text" class="form-control address" placeholder="Address" name="address" value="<?= @$head->address ?>">
					<input type="text" class="form-control address_h" placeholder="Address" name="address_h" value="<?= @$head->address_h ?>" readonly />
				</div>
				<div class="col-md-4">
					<label for="city" class="form-label">City</label>
					<input type="text" class="form-control city" placeholder="City" name="city" value="KANPUR" readonly />
					<input type="text" class="form-control city_h" placeholder="City" name="city_h" value="कानपुर" readonly />
				</div>
				<div class="col-md-4">
					<label for="pincode" class="form-label">Pincode</label>
					<input type="number" class="form-control pincode" placeholder="Pincode" name="pincode" value="<?= @$head->pincode ?>" min="0" />
					<input type="text" class="form-control pincode_h" placeholder="Pincode" value="<?= @$head->pincode ?>" readonly />
				</div>

				<div class="col-12 d-flex justify-content-end">
					<button type="submit" class="btn btn-success">Save</button>
				</div>
			</form>
		</div>
	</div>

	<?php if( @$head->name ): ?>
    <div class="section__header text-center">
        <h2>Family Members</h2>
    </div>


    <div class="card">
    	<div class="card-body">
    		<?php if( strtotime(@$head->due_date) <= strtotime('Y-m-d') || !@$head->due_date ): ?>
    		<button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#staticBackdrop" data-url="<?= $member_create ?>" data-whatever="Add New Member">Add New Member</button>
    		<?php endif; ?>

    		<div class="table-responsive">
    		<table class="table table-striped table-hover">
				<thead>
					<tr>
						<th>Name (नाम)</th>
						<th>Mobile (फ़ोन)</th>
						<th>Relation (संबंध)</th>
						<th>Age (आयु)</th>
						<th>Aadhar (आधार संख्या)</th>
						<th>Action (क्रिया)</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach( $members as $row ): ?>
					<tr>
						<td> <?= $row->name ?> (<?= $row->name_h ?>) </td>
						<td> <?= $row->mobile ?> </td>
						<td>
							<?php 
								if( $row->relation ):
									echo $row->relation_en.' ('.$row->relation_h.')';
								else:
									echo 'Family Head';
								endif;
							?>
						</td>
						<td> <?= $row->age ?> </td>
						<td> <?= $row->aadhar ?> </td>
						<td>
							<a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#staticBackdrop" data-url="<?= $member_create ?><?= $row->id ?>" data-whatever="Edit Member">
								<i class="fas fa-edit"></i>
							</a>							
						</td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
			</div>
			</form>
    	</div>
    </div>

    <div class="row justify-content-center">
    	<div class="col-md-4">
    		<div class="card">
		    	<div class="card-body">
		    		<form action="<?= $checkout_url ?>" class="checkout-form" method="POST">
			    		<div class="table-responsive">
	    					<table class="table table-striped table-hover">
	    						<tr>
	    							<th>No. Of Member:</th>
	    							<th class="text-right"><strong class="no-of-member"><?= $no_of_member ?></strong></th>
	    						</tr>
	    						<tr>
	    							<th>Per Member Donation:</th>
	    							<th class="text-right"><strong>₹ <?= _nf($charge->per_member_charge) ?> </strong></th>
	    						</tr>
	    						<tr>
	    							<th>Total Donation:</th>
	    							<th class="text-right">
	    								<strong class="no-of-member">₹ <?= _nf($total_amount) ?> </strong>
	    							</th>
	    						</tr>
	    						<?php if( strtotime(@$head->due_date) <= strtotime('Y-m-d') || !@$head->due_date ): ?>
	    						<tr class="<?= is_loggedin() ? '' : 'd-none' ?>">
	    							<th>Receipt No.</th>
	    							<th>
	    								<input type="text" class="form-control" name="receipt_no" value="" autocomplete="off" <?= is_loggedin() ? 'required' : '' ?>>
	    							</th>
	    						</tr>
	    						<tr class="<?= is_loggedin() ? '' : 'd-none' ?>">
	    							<th>Receipt Date</th>
	    							<th>
	    								<input type="date" class="form-control" name="manual_date" value="" autocomplete="off" <?= is_loggedin() ? 'required' : '' ?>>
	    							</th>
	    						</tr>
	    						<tr class="<?= !is_loggedin() ? '' : 'd-none' ?>">
	    							<th>Pay On This UPI </th>
	    							<th class="text-right text-info">
	    								<span> 9336101742@upi </span>
	    								<span> ravishikha@okicici </span>
	    							</th>
	    						</tr>
	    						<tr class="<?= !is_loggedin() ? '' : 'd-none' ?>">
	    							<th>UPI Transaction Number</th>
	    							<th>
	    								<input type="text" class="form-control" name="transaction_no" value="" autocomplete="off" <?= !is_loggedin() ? 'required' : '' ?>>
	    							</th>
	    						</tr>
	    						<!-- <tr>
	    							<th colspan="2">
	    								<button type="submit" class="btn btn-success">Make Payment</button>
	    							</th>
	    						</tr> -->
	    						<tr>
	    							<th colspan="2" class="text-center">
	    								<button type="submit" class="btn btn-success">Pay Now & Submit</button>
	    							</th>
	    						</tr>
	    						<?php else: ?>
	    							<tr>
		    							<th colspan="2" class="text-center">
		    								<button type="button" class="btn btn-success">Registered</button>
		    							</th>
		    						</tr>
	    						<?php endif; ?>
	    					</table>
	    				</div>
    				</form>
		    	</div>
		    </div>		
    	</div>
    	<!-- end col -->

    	<div class="col-md-4">
    		<div class="card">
		    	<div class="card-body">
		    		<img src="<?= base_url('statics/images/banner/qr.png') ?>" class="img-thumbnail" />
		    	</div>
		    </div>
    	</div>
    </div>
	<?php endif; ?>
    
</div>



<script type="text/javascript">
	$(document).ready(function(){
		$('.head-form').validate({
			rules : {
				name:{
					required : true
				},
		        mobile : { 
		        	required : true,
		        	minlength : 10,
		        	maxlength : 10,
		        	remote : '<?= base_url() ?>member/check_mobile/head/<?= @$head->id ?>'
		        },
		        aadhar:{
		        	required : true,
		        	minlength : 4,
		        	maxlength : 4,
		        	remote : '<?= base_url() ?>member/check_aadhar/head/<?= @$head->id ?>'
		        },
		        father_husband: 'required',
		        address : 'required',
		        age : 'required',
		        pincode :{
		        	required : true,
		        	minlength : 6,
		        	maxlength : 6,
		        	number : true
		        }
		    },
		    messages:{
		    	mobile:{
		    		required : 'Moible number is required!',
		    		minlength: 'Please enter 10 digit mobile number',
		    		maxlength: 'Please enter 10 digit mobile number',
		    		remote: 'This Moible is already exist!'
		    	},
		    	aadhar:{
		    		minlength: 'Please enter last 4 digit of aadhar',
		    		maxlength: 'Please enter last 4 digit of aadhar',
		    		remote : 'This aadhar No is already exists!'
		    	}
		    }
		});


		$('.checkout-form').validate();

	});
</script>