<div class="container padding--top padding--bottom">
    <div class="row">
    	<div class="col-md-8 bg-light">

    		<div class="section__header">
		        <h2>Profile</h2>
		        <p></p>
		    </div>

			<form class="row g-3 user-form ajax-submit page-reload" method="POST" action="<?= $action_url ?>">
				<input type="hidden" name="id" value="<?= @$row->id ?>">

				<div class="col-md-12">
					<label for="name" class="form-label">Name</label>
					<input type="text" class="form-control name" placeholder="Name" name="name" value="<?= @$row->name ?>" />
				</div>

				<div class="col-md-12">
					<label for="user_name" class="form-label">Username</label>
					<input type="text" class="form-control user_name" placeholder="Username" name="user_name" autocomplete="off" value="<?= @$row->user_name ?>" />
				</div>

				<div class="col-md-12">
					<label for="email" class="form-label">Email</label>
					<input type="text" class="form-control email" placeholder="Email" name="email" autocomplete="off" value="<?= @$row->email ?>" />
				</div>
				<div class="col-md-12">
					<label for="mobile" class="form-label">Mobile</label>
					<input type="number" class="form-control mobile" placeholder="mobile" name="mobile" autocomplete="off" value="<?= @$row->mobile ?>" />
				</div>

				<div class="col-md-12">
					<label for="address" class="form-label">Address</label>
					<textarea class="form-control address" name="address"><?= @$row->address ?></textarea>

				</div>

				<div class="col-12 d-flex justify-content-end">
					<button type="submit" class="btn btn-success">Save</button>
				</div>
			</form>    		
    	</div>

    	<!-- password change -->
    	<div class="col-md-4 bg-light">
    		<div class="section__header">
		        <h2>Change Password</h2>
		        <p></p>
		    </div>
			<form class="row g-3 password-form ajax-submit page-reload" method="POST" action="<?= $change_password ?>">
				<div class="col-md-12">
					<label for="old_password" class="form-label">Old Password</label>
					<input type="text" class="form-control name" placeholder="Old Password" name="old_password" value="" autocomplete="off" />
				</div>
				<div class="col-md-12">
					<label for="new_password" class="form-label">New Password</label>
					<input type="text" class="form-control name" placeholder="New Password" name="new_password" value="" id="new_password" autocomplete="off" />
				</div>
				<div class="col-md-12">
					<label for="confirm_password" class="form-label">Confirm Password</label>
					<input type="text" class="form-control name" placeholder="Confirm Password" name="confirm_password" value="" autocomplete="off" />
				</div>

				<div class="col-12 d-flex justify-content-end">
					<button type="submit" class="btn btn-success">Save</button>
				</div>
			</form>
    	</div>
    </div>

</div>




<script type="text/javascript">
	$(document).ready(function(){
		$('.user-form').validate({
			rules : {
				name:{
					required : true,
				},
		        email : {
		        	required : true,
		        	email : true,
		        },
		        mobile:{
		        	required : true,
		        	minlength : 10,
		        	maxlength : 10
		        },
		        user_name : {
		        	required : true,
		        	remote : '<?= base_url('users/check_username/').@$row->id ?>'
		        },
		    },
		    messages:{
		    	mobile:{
		    		minlength: 'Please enter 10 digit mobile number',
		    		maxlength: 'Please enter 10 digit mobile number',
		    		remote: 'This Moible is already exist!'
		    	},
		    	user_name:{
		    		remote : 'This Username is already exists!'
		    	}
		    }
		});


		$('.password-form').validate({
			rules:{
                old_password:{
                    required : true,
                    remote : "<?= base_url() ?>users/check_password/<?= @$row->id ?>"
                },
                new_password:{
                    required: true,
                    minlength: 4
                },
                confirm_password:{
                    required: true,
                    minlength: 4,
                    equalTo : '#new_password'
                }
            },
            messages:{
                old_password:{
                    remote : 'Password does not match with your current password'
                },
                confirm_password:{
                    equalTo: 'Password did not match with new password'
                }
            }
		});
	});
</script>