<form class="row g-3 user-form ajax-submit page-reload" method="POST" action="<?= $action_url ?>">
	<input type="hidden" name="id" value="<?= @$row->id ?>">

	<div class="col-md-12">
		<label for="name" class="form-label">Name</label>
		<input type="text" class="form-control name" placeholder="Name" name="name" value="<?= @$row->name ?>" />
	</div>
	<div>
		<label for="role" class="form-label">Role</label>
		<?php
			$roles = $this->app_lib->get_role();
			echo form_dropdown('role_id', $roles, set_value('role_id', @$row->role_id), "class='form-control'")
		?>
	</div>
	<div class="col-md-12">
		<label for="email" class="form-label">Email</label>
		<input type="text" class="form-control email" placeholder="Email" name="email" autocomplete="off" value="<?= @$row->email ?>" />
	</div>
	<div class="col-md-12">
		<label for="mobile" class="form-label">Mobile</label>
		<input type="number" class="form-control mobile" placeholder="mobile" name="mobile" autocomplete="off" value="<?= @$row->mobile ?>" />
	</div>

	<div class="col-md-12">
		<label for="address" class="form-label">Address</label>
		<textarea class="form-control address" name="address"><?= @$row->address ?></textarea>

	</div>

	<div class="col-md-12">
		<label for="user_name" class="form-label">Username</label>
		<input type="text" class="form-control user_name" placeholder="Username" name="user_name" autocomplete="off" value="<?= @$row->user_name ?>" />
	</div>

	<div class="col-md-12">
		<label for="password" class="form-label">Password</label>
		<input type="text" class="form-control password" placeholder="Password" name="password" autocomplete="off" value="<?= @$row->password ?>" />
	</div>

	<div>
		<label for="role" class="form-label">Status</label>
		<?php
			$status = array(
				'' => 'Select',
				'1' => 'Active',
				'2' => 'Inactive'
			);
			echo form_dropdown('status', $status, set_value('status', @$row->status), "class='form-control'")
		?>
	</div>
	

	<div class="col-12">
		<button type="submit" class="btn btn-success">Save</button>
	</div>
</form>



<script type="text/javascript">
	$(document).ready(function(){
		$('.user-form').validate({
			rules : {
				name:{
					required : true,
				},
		        role_id : {
		        	required : true,
		        },
		        email : {
		        	required : true,
		        	email : true,
		        },
		        mobile:{
		        	required : true,
		        	minlength : 10,
		        	maxlength : 10
		        },
		        user_name : {
		        	required : true,
		        	remote : '<?= base_url('users/check_username/').@$row->id ?>'
		        },
		        password:{
		        	required: true,
		        	minlength : 4
		        },
		        status:{
		        	required: true
		        }
		    },
		    messages:{
		    	mobile:{
		    		minlength: 'Please enter 10 digit mobile number',
		    		maxlength: 'Please enter 10 digit mobile number',
		    		remote: 'This Moible is already exist!'
		    	},
		    	user_name:{
		    		remote : 'This Username is already exists!'
		    	}
		    }
		});
	});
</script>